/*
 * VRML plugin
 */

/******************************************/
/*                                        */
/*    RenderWare(TM) Graphics Library     */
/*                                        */
/******************************************/

/*
 * This file is a product of Criterion Software Ltd.
 *
 * This file is provided as is with no warranties of any kind and is
 * provided without any obligation on Criterion Software Ltd.
 * or Canon Inc. to assist in its use or modification.
 *
 * Criterion Software Ltd. and Canon Inc. will not, under any
 * circumstances, be liable for any lost revenue or other damages
 * arising from the use of this file.
 *
 * Copyright (c) 1998. Criterion Software Ltd.
 * All Rights Reserved.
 */

/****************************************************************************
 *                                                                         
 * VRML 2.0 to RW3.0 Converter
 * Copyright (C) 1997 Criterion Technologies
 *
 * Author  : Damian Scallan 
 *
 * Module  : RpVrml.h
 *                                                                         
 * Purpose : RW3.0 interface to the vrml library
 *                         
 ****************************************************************************/

#ifndef RPVRML_H
#define RPVRML_H

/**
 * \defgroup rpvrml RpVRML
 * \ingroup retired
 * 
 * VRML Plug-In for RenderWare.
 */

/****************************************************************************
 Includes
 */

#ifndef _RPVRML_H
#define _RPVRML_H
#include <rwcore.h>
#include <rpworld.h>

#include <rpcriter.h>          /* Note: each vendor can choose their own method for
                                * allocation of unique ID's. This file defines 
                                * the ID's used by Criterion.
                                */

#include "rpvrml.rpe"          /* automatically generated header file */

#endif /* _RPVRML_H */

/****************************************************************************
 Function prototypes
 */

#ifdef    __cplusplus
extern          "C"
{
#endif         /* __cplusplus */

extern RwBool
RpVrmlPluginAttach(void);

extern    RpWorld        *
RpVrmlWorldRead(const char *filename, RwReal scale);

extern    RpClump        *
RpVrmlClumpRead(const char *filename, RwReal scale);

extern    RpClump        *
RpVrmlClumpAddCreaseNormals(RpClump * clump, RwReal creaseAngle);

extern RpClump *
RpVrmlClumpAnimAddTime(RpClump *clump, RwReal time);
    
/* non API */

extern void    *
_rpVrmlAnimOpen(void *instance, RwInt32 offset, RwInt32 size);

extern void *
_rpVrmlClose(void *instance, RwInt32 offset,  RwInt32 size);
    
extern void    *
_rpVrmlOpen(void *instance, RwInt32 offset, RwInt32 size);

#ifdef    __cplusplus
}
#endif         /* __cplusplus */

#endif         /* RPVRML_H */
