/***************************************************************************
 *                                                                         *
 * Module  : drvfns.h (nullsky)                                            *
 *                                                                         *
 * Purpose : Driver functionality                                          *
 *                                                                         *
 **************************************************************************/

#ifndef DRVFNS_H
#define DRVFNS_H

#include "batypes.h"
#include "bacolor.h"
#include "batextur.h"


/* Lets hope that gcc's constant folding works */

/* RWPUBLIC */

enum RpSkyRenderState
{
    rpSKYRENDERSTATENARENDERSTATE = 0,
	rpSKYRENDERSTATEMAXMIPLEVELS, /* Max number of mip levels rasters are created
	                               * with. Must be <= 7. Mip levels are still only
	                               * created if >8 texels in both dimensions. */

    rpSKYRENDERSTATEFORCEENUMSIZEINT = RWFORCEENUMSIZEINT
};
typedef enum RpSkyRenderState RpSkyRenderState;

/****************************************************************************
 Function prototypes
 */
#ifdef    __cplusplus
extern "C"
{
#endif                          /* __cplusplus */

extern RwReal RpSkyTextureSetDefaultMipmapK(RwReal val);
extern RwUInt32 RpSkyTextureSetDefaultMipmapL(RwUInt32 val);
extern RwReal RpSkyTextureGetDefaultMipmapK(void);
extern RwUInt32 RpSkyTextureGetDefaultMipmapL(void);
extern RwTexture *RpSkyTextureSetMipmapK(RwTexture *tex, RwReal val);
extern RwTexture *RpSkyTextureSetMipmapL(RwTexture *tex, RwUInt32 val);
extern RwReal RpSkyTextureGetMipmapK(RwTexture *tex);
extern RwUInt32 RpSkyTextureGetMipmapL(RwTexture *tex);

extern RwBool RpSkyRenderStateSet(RpSkyRenderState nState, void *pParam);
extern RwBool RpSkyRenderStateGet(RpSkyRenderState nState, void *pParam);

#ifdef    __cplusplus
}
#endif                          /* __cplusplus */

/* RWPUBLICEND */

#endif /* DRVFNS_H */
