; ***************************************************************************
;
; Module        : baprocfp.asm
;
; Purpose       : Processor floating point mode stuff
;
; ***************************************************************************

; ***************************************************************************
; Includes

        include macros.i

RWASM386

; ***************************************************************************
; Data segment

RWASMDATASEGMENTBEGIN
        _rwFPUCtrl      dd		0	; FPU State
		_rwFPUSaveState dd		0
RWASMDATASEGMENTEND

; ***************************************************************************
; Code segment

RWASMCODESEGMENTBEGIN

; ***************************************************************************
; _rwProcessorInitialize

RWASMFUNC _rwProcessorInitialize
        push eax

        fstcw WORD PTR [_rwFPUCtrl]             ; 2

        mov eax,DWORD PTR [_rwFPUCtrl]

        mov [_rwFPUSaveState],eax               ; For restore later
        and eax,0fcffh                             ; 24 bit precision

        ; Always round towards -infinity

        and eax,0f3ffh                          ; Mask
        or eax,00400h                           ; Set rounding

        ; Done

        mov DWORD PTR [_rwFPUCtrl],eax

        fldcw WORD PTR [_rwFPUCtrl]             ; 7

        pop eax
	ret

; ***************************************************************************
; _rwProcessorRelease
    
RWASMFUNC _rwProcessorRelease
        fldcw WORD PTR [_rwFPUSaveState]        ; 7
	ret

RWASMCODESEGMENTEND

	end
