//	===========================================================================
//	mwUtils_PS2AT.h			2000 Metrowerks Inc. All rights reserved.
//	===========================================================================
//
//	Metrowerks Utilities
//
//	Version.1.0
//
//	10/20/2000	kashima,	new

#pragma once

#ifndef	__MWUTILSPS2_H__
#define	__MWUTILSPS2_H__

/*******************************************************************************
	INCLUDE
*******************************************************************************/
/*	OS dependent header	*/
/*	STANDARD header	*/
/*	PROJECT header	*/

#ifdef __cplusplus
extern	"C"	{
#endif

/*******************************************************************************
	DEFINE
*******************************************************************************/

#define	printf	mwAtPrintf

/*******************************************************************************
	TYPEDEF
*******************************************************************************/

/*******************************************************************************
	EXTERN
*******************************************************************************/

/*******************************************************************************
	FUNCTION
*******************************************************************************/

/*------------------------------------------------------------------------------
 *	mwAtInit
 *	initialize MW artist tool utility
 *	NOTE: you have to path argv[0] for main() to the parameter "argv0"
------------------------------------------------------------------------------*/
void		mwAtInit(const char *argv0);

/*------------------------------------------------------------------------------
 *	mwAtExit
 *	cleanup MW artist tool utility
------------------------------------------------------------------------------*/
void		mwAtExit(void);

/*------------------------------------------------------------------------------
 *	host IO for artist monitor
------------------------------------------------------------------------------*/
int			mwAtOpen(char *filename, int flag);
void		mwAtClose();

#define		mwAtRead(fd, buf, nbyte)		sceRead(fd, buf, nbyte)
#define		mwAtWrite(fd, buf, nbyte)		sceWrite(fd, buf, nbyte)
#define		mwAtLseek(fd, offset, whence)	sceLseek(fd, offset, whence)

/*------------------------------------------------------------------------------
 *	mwAtPrintf
 *	printf for artist monitor
 *	CAUTION: this works only with MW tools
------------------------------------------------------------------------------*/
void		mwAtPrintf(const char *fmt, ...);

/*------------------------------------------------------------------------------
 *	mwAtGetFd
 *	return fd of log file (used only for IOP)
------------------------------------------------------------------------------*/
int			mwAtGetFd();

#ifdef __cplusplus
}
#endif	/* __cplusplus */

#endif	/* __MWUTILSPS2_H__ */